@extends('admin.admin_dashboard_'.Session::get('siso')) 
@section('content')
<link rel="stylesheet" href="{{ URL::asset('css/plugins/datepicker-bs5.min.css')}}">

				
<div class="pc-container">
    <div class="pc-content">
      <!-- [ breadcrumb ] start -->
      <div class="page-header">
        <div class="page-block">
          <div class="row align-items-center">
            <div class="col-md-12">
              <ul class="breadcrumb mb-3">
                <li class="breadcrumb-item"><a href="../home">Home</a></li>
                <li class="breadcrumb-item"><a href="../promociones">Promociones</a></li>
                <li class="breadcrumb-item" aria-current="page">Agregar Promoción</li>
              </ul>
            </div>
            <div class="col-md-12">
              <div class="page-header-title">
                <h2 class="mb-0">Agregar Promoción</h2>
              </div>
            </div>
          </div>
        </div>
      </div>
      <!-- [ breadcrumb ] end -->

      <!-- [ Main Content ] start -->
      <div class="row">
        <!-- [ sample-page ] start -->
        <div class="col-sm-12">
          <div class="card">
            <div class="card-body"> 
               <form class="smart-form" enctype="multipart/form-data"  method="POST" action="{{ route('promocion/save')}}">
                @csrf 
               	
              <div class="row"> 
                

                <div class="col-md-4"> 
                  <div class="form-group">
                    <label class="form-label">Descripción</label> 
                    <input id="descripcion" name="descripcion" type="text" class="form-control" placeholder=""  value="{{ (old('descripcion')) }}"> 
                    @error('descripcion')<span class="fs-6 text-danger">El campo de Lugar es requerido </span> @enderror
                  </div> 
               </div>

               <div class="col-md-4"> 
                  <div class="form-group">
                    <label class="form-label">Banco</label> 
                    <select id="bancos" name="bancos" class="form-control"  >
                          <option value="0">Seleccione Banco</option>
                            @foreach($bancos as $bancos)  
                              <option value="{{$bancos->id}}">{{$bancos->nombre}}</option>
                            @endforeach
                        </select> <i id="i_bancos" ></i>

                           

                  </div> 
               </div>


                <div class="col-md-4"> 
                  <div class="form-group">
                    <label class="form-label">Archivo</label> 
                    <input type="file" id="attachment" name="attachment" class="form-control" />
                  </div> 
               </div>



               

             </div>

              <div class="row"> 


                <div class="col-md-4"> 
                  <div class="form-group">
                    <label class="form-label">Fecha Inicio</label> 
                    <input id="fecha_ini" name="fecha_ini" type="text" class="form-control" placeholder=""> 
                    @error('fecha_ini')<span class="fs-6 text-danger">El campo de Fecha es requerido </span> @enderror
                  </div> 
               </div> 

               <div class="col-md-4"> 
                  <div class="form-group">
                    <label class="form-label">Fecha Final</label> 
                    <input id="fecha_fin" name="fecha_fin" type="text" class="form-control" placeholder=""  > 
                    @error('fecha_fin')<span class="fs-6 text-danger">El campo de Fecha es requerido </span> @enderror
                  </div> 
               </div> 

               <div class="col-md-4"> 
                  <div class="form-group">
                    <label class="form-label">Fecha Firmar / Disp.</label> 
                    <input id="fecha_firmar" name="fecha_firmar" type="text" class="form-control" placeholder="" > 
                    @error('fecha_firmar')<span class="fs-6 text-danger">El campo de Fecha es requerido </span> @enderror
                  </div> 
               </div> 
                

               

              </div>

              <div class="row">

                <div class="col-md-4"> 
                    <a href="{{ route('promociones/list')}}" class="btn btn-outline-secondary">Regresar</a> 
                    <button type="submit" class="btn btn-primary">Agregar Promoción</button>
                 
                </div>  

              </div>
              </form> 


            </div>
          </div>
        </div>
        <!-- [ sample-page ] end -->
      </div>
      <!-- [ Main Content ] end -->
    </div>
  </div>

          <!-- DOM/Jquery table end -->
<!--main--> 

    <!-- datatable Js --> 
 
<style> 
.ui-datepicker-calendar {
    display: none;
    }
</style>
 
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
<script src="{{ URL::asset('js/plugins/jquery.dataTables.min.js')}}"></script>
<script src="{{ URL::asset('js/plugins/dataTables.bootstrap5.min.js')}}"></script>
<script src="{{ URL::asset('js/plugins/dataTables.responsive.min.js')}}"></script>
<script src="{{ URL::asset('js/plugins/responsive.bootstrap5.min.js')}}"></script>
<script src="{{ URL::asset('js/plugins/datepicker-full.min.js')}}"></script>

<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.10.2/jquery.min.js"></script>  
  
  <script src="https://code.jquery.com/ui/1.13.2/jquery-ui.js"></script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/1.1.3/sweetalert.min.js"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.8.0/js/bootstrap-datepicker.min.js"></script>
 
 
    <script>

       $("#fecha_ini").datepicker( {   
    todayBtn: "linked", 
            keyboardNavigation: false,
            forceParse: false, 
            autoclose: true
});  

        $("#fecha_fin").datepicker( {   
    todayBtn: "linked", 
            keyboardNavigation: false,
            forceParse: false, 
            autoclose: true
});  

         $("#fecha_firmar").datepicker( {   
    todayBtn: "linked", 
            keyboardNavigation: false,
            forceParse: false, 
            autoclose: true
});  
      // [ DOM/jquery ] 
 $(document).ready(function()
            {
    ;
                
    }); // FIN DE TABLA
 </script>

@endsection